<?php

namespace VM\ApiBundle\Repository;

use Doctrine\ORM\EntityRepository;

/**
 * UserRepository
 *
 * This class was generated by the Doctrine ORM. Add your own custom
 * repository methods below.
 */
class UserRepository extends EntityRepository
{
    /**
     * Get list of internal users not deleted
     *
     * @param $from - 0 ... number_of_users
     * @param $limit - limit for request
     * @param $order - order like array('name' => 'ASC', 'surname' => 'DESC')
     * @return array
     */
    public function getUsers($from, $limit, $order)
    {
        $QueryBuilder = $this->getUsersQueryBuilder($from, $limit, $order);
        $this->addInternalAndNotDeleted($QueryBuilder);

        return $QueryBuilder->getQuery()->getResult();
    }

    /**
     * Add to QueryBuilder clauses for internal_user and not_deleted
     *
     * @param \Doctrine\ORM\QueryBuilder $QueryBuilder
     * @return \Doctrine\ORM\QueryBuilder
     */
    protected function addInternalAndNotDeleted(\Doctrine\ORM\QueryBuilder $QueryBuilder)
    {
        $QueryBuilder->andWhere('u.internal_user = 1');
        $QueryBuilder->andWhere('u.is_deleted = 0');
        return $QueryBuilder;
    }



    /**
     * Create QueryBuilder
     *
     * @param $from
     * @param $limit
     * @param array $order
     * @return \Doctrine\ORM\QueryBuilder
     */
    protected function getUsersQueryBuilder($from, $limit, $order = array())
    {
        $QueryBuilder = $this->createQueryBuilder('u')
            ->select('u')
        ;
        if(!empty($from))
        {
            $QueryBuilder->setFirstResult($from);
        }

        if(!empty($limit))
        {
            $QueryBuilder->setMaxResults($limit);
        }

        if(!empty($order))
        {
            foreach($order as $key => $sort)
            {
                $QueryBuilder->orderBy('u.' . $key, $sort);
            }
        }

        return $QueryBuilder;
    }


    /**
     * Get user or throw exception
     *
     * @param $userId
     * @return \Diagnostic\UserBundle\Entity\User
     * @throws \Json\RpcBundle\JsonRpcException
     */
    public function getUser($userId)
    {
        $User = $this->find($userId);
        if(empty($User))
        {
            throw new JsonRpcException('User not exist', 0);
        }

        return $User;
    }

}